﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using BMS.Facade;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.Web.App_GlobalResource;
using BMS.Web.Models;
using InfoWorld.HL7.ITS;
using Microsoft.Web.Mvc;
using BMS.Facade.Fault;
using System.Text;
using VI = BMS.VistaIntegration.FacadeContracts;

namespace BMS.Web.Controllers
{
    /// <summary>
    /// Home Controller class.
    /// </summary>
    [ValidateInput(false)]
    public class HomeController : BaseController
    {

        /// <summary>
        /// Default action for the Home controller.
        /// </summary>
        /// <returns>Returns the Home view result.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return Index2(null);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Default action for the Home controller.
        /// </summary>
        /// <returns>Returns the Home view result.</returns>
        [ReadPermissionAuthFilter]
        public ActionResult Index2(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                HomeViewModel hm = new HomeViewModel();
                hm.FacilityTime = DateTimeNowOnCurrentFacility;
                hm.View2 = string.IsNullOrEmpty(p) ? Strings.View_Standard : string.IsNullOrEmpty(QueryStrings["view"]) ? Strings.View_Standard : QueryStrings["view"];
                hm.LastSelectedView = string.IsNullOrEmpty(p) ? Strings.View_Standard : string.IsNullOrEmpty(QueryStrings["lastView"]) ? Strings.View_Standard : QueryStrings["lastView"];
                hm.CurrentFilter = string.IsNullOrEmpty(p) ? Strings.WaitingList_Current : string.IsNullOrEmpty(QueryStrings["filter"]) ? Strings.WaitingList_Current : QueryStrings["filter"];
                FillViewModel(hm);
                return View("Index", hm);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Post action for the Home controller  - used for the waiting list buttons and drop downs.
        /// </summary>        
        /// <param name="buttonName">Name of the button.</param>
        /// <param name="buttonHiddenView">The button hidden view.</param>
        /// <param name="buttonHiddenSort">The button hidden sort.</param>
        /// <param name="input">The input (home model).</param>
        /// <returns>Returns the Home view result.</returns>
        [HttpPost]
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index(HomeViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!string.IsNullOrWhiteSpace(input.GoToSelectedFacilitySite))
                {
                    if (input.SelectedFacilitySiteExtension != Strings.PickADifferentSite)
                    {
                        Facility facility = FacadeManager.EntityInterface.GetFacility(new II(this.loggedUser.Domain, input.SelectedFacilitySiteExtension));
                        if (facility != null)
                        {
                            if (facility.IsAlive == false)
                                input.ChangeIntegratedSiteError = Strings.FacilityIsNotAlive;
                            if (facility.VistaSite.Visn == null)
                                input.ChangeIntegratedSiteError = Strings.TheFacilityDoesntHaveAnAssociatedVISN;
                            if (facility.VistaSite.Visn.Region == null)
                                input.ChangeIntegratedSiteError = Strings.TheVISNOnFacilityDoesntHaveAnAssociatedRegion;
                        }
                        else
                        {
                            input.ChangeIntegratedSiteError = Strings.FacilityNotFound;
                        }

                        if (!string.IsNullOrEmpty(input.ChangeIntegratedSiteError))
                        {
                            return this.RedirectToAction<HomeController>(act => act.ChangeIntegratedSiteError(EncryptQueryString(new string[] { "message", "facilityName", "facilityCode" }, new string[] { input.ChangeIntegratedSiteError, this.loggedUser.Facility.Name, this.loggedUser.Facility.Code }, loggedUser.Salt)));
                        }
                        else
                        {
                            this.loggedUser.Facility = facility;
                            this.loggedUser.Visn = facility.VistaSite.Visn;
                            this.loggedUser.Region = facility.VistaSite.Visn.Region;
                            return this.RedirectToAction<HomeController>(act => act.Index());
                        }
                    }
                }
                return this.RedirectToAction<HomeController>(act => act.Index2(EncryptQueryString(new string[] { "filter", "view", "lastView"  }, new string[] { input.FilterOperation ?? input.CurrentFilter, input.View2, input.LastSelectedView }, loggedUser.Salt)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ActionResult ChangeIntegratedSiteError(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ViewBag.ErrorMessage = QueryStrings["message"];
                ViewBag.FacilityName = QueryStrings["facilityName"];
                ViewBag.FacilityCode = QueryStrings["facilityCode"];
                return View();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Action for rendering the AdmissionList in Home partial View
        /// </summary>
        /// <param name="input">The input (home model).</param>
        /// <returns>Returns the AdmissionList partial view result.</returns>
        public PartialViewResult AdmissionList(HomeViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                //Generate the table columns based on the selected value from the View drop down.
                input.LoggedUser = loggedUser;
                if (input.View2Selected.displayName.Equals(Strings.View_Standard))
                    return PartialView("StandardAdmissionList", input);
                else if (input.View2Selected.displayName.Equals(Strings.View_FeeUtilization))
                    return PartialView("FeeUtilizationAdmissionList", input);
                else if (input.View2Selected.displayName.Equals(Strings.View_PatientFlow))
                    return PartialView("PatientFlowAdmissionList", input);
                else if (input.View2Selected.displayName.Equals(Strings.View_InHouse))
                    return PartialView("PatientInHouseAdmissionList", input);
                else
                    return PartialView("StandardAdmissionList", input);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Action for redirecting to the edit view.
        /// </summary>
        /// <returns>The Edit View.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Edit()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return View();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Action for redirecting to the remove view.
        /// </summary>
        /// <returns>The Remove View</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult RemoveAdmission(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                HomeRemoveAdmissionViewModel model = new HomeRemoveAdmissionViewModel();
                model.LoggedUser = loggedUser;
                model.IdAdmission = p;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Action for redirecting to the undo remove view.
        /// </summary>
        /// <returns>The Undo Remove View</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult UndoRemoveAdmission(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                HomeRemoveAdmissionViewModel model = new HomeRemoveAdmissionViewModel();
                model.LoggedUser = loggedUser;
                model.IdAdmission = p;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Action for redirecting to the remove view.
        /// </summary>
        /// <returns>The Remove View</returns>
        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult RemoveAdmissionPost(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WaitingListItem waitingListItem = FacadeManager.ADTInterface.GetWaitingListItem(new II(this.loggedUser.Domain, QueryStrings["idAdmission"]), loggedUser);
                waitingListItem.RemovedDate = DateTimeNowOnCurrentFacility;
                waitingListItem.LastEditBy = this.loggedUser.UserName;
                FacadeManager.WorkflowInterface.RemoveFromWaitingList(waitingListItem, loggedUser.Facility);
                return View("AdmissionSuccessRemove", (object)QueryStrings["idAdmission"]);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Action for redirecting to the undo remove view.
        /// </summary>
        /// <returns>The undo Remove View</returns>
        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult UndoRemoveAdmissionPost(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WaitingListItem waitingListItem = FacadeManager.ADTInterface.GetWaitingListItem(new II(this.loggedUser.Domain, QueryStrings["idAdmission"]), loggedUser);
                waitingListItem.RemovedDate = null;
                waitingListItem.LastEditBy = this.loggedUser.UserName;
                FacadeManager.WorkflowInterface.UndoRemoveFromWaitingList(waitingListItem, loggedUser.Facility);
                return View("AdmissionSuccessUndoRemove", (object)QueryStrings["idAdmission"]);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Action to load the time view from the top of the page.
        /// </summary>
        /// <returns>TimeRefresh partial view.</returns>
        public PartialViewResult TimeRefresh()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return PartialView("TimeRefresh");
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilterAttribute]
        public ActionResult PatientInquiry(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                PatientInquiryViewModel model = new PatientInquiryViewModel();
                model.SelectedPatient = FacadeManager.EntityInterface.GetPatientById(new II(loggedUser.Domain, QueryStrings["patientId"]), null);
                model.Header = Strings.ReportDate + ": " + DateTimeNowOnCurrentFacility.ToString();
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #region Private Methods

        /// <summary>
        /// Fills the controls with data from Facade.
        /// </summary>
        /// <param name="hm">The home model.</param>
        private void FillViewModel(HomeViewModel hm)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SetView2Selected(hm);
                hm.LoggedUser = this.loggedUser;
                FacilitySettings facilitySettings = null;
                bool isEvacuation = false;
                string marquee = null;
                List<Module> flags = null;
                FacadeManager.ConfigurationInterface.GetConfigurationsForHomePage(this.loggedUser.Facility.Id, out isEvacuation, out marquee, out facilitySettings, out flags);
                hm.MarqueeText = marquee;
                hm.IsEvacuation = isEvacuation;
                if (facilitySettings != null)
                {
                    if (facilitySettings.IntegratedFacility != null && facilitySettings.IntegratedFacility.code == Constants.Yes && facilitySettings.IntegratedSiteSisterGroupId != 0)
                    {
                        SisterSitesGroup group = facilitySettings.SisterSitesGroups.Where(a => a.RecordNumber == facilitySettings.IntegratedSiteSisterGroupId && !string.IsNullOrEmpty(a.SiteCodeList) && a.SiteCodeList.Contains(this.loggedUser.Facility.Id.extension)).FirstOrDefault();
                        if (group != null)
                        {
                            if (!string.IsNullOrEmpty(facilitySettings.IntegratedSiteSisterList))
                                hm.IntegratedSites = BuildIntegratedSites(facilitySettings.IntegratedSiteSisterList, this.loggedUser.Facility);
                            else
                                hm.IntegratedSites = new List<Facility>();
                            hm.IntegratedSites.Insert(0, new Facility() { Id = new II() { root = this.loggedUser.Facility.Id.root, extension = Strings.PickADifferentSite }, Name = Strings.PickADifferentSite });
                        }
                    }
                }
                hm.AdmissionList = new List<AdmissionInfo>();
                hm.DiversionExists = FacadeManager.DiversionInterface.GetDiversions(this.loggedUser.Facility.Id).Where(div => div.Status == Constants.Yes && div.StartDate != null).ToList().Count > 0 ? true : false;
                if (hm.DiversionExists)
                {
                    hm.DiversionNo = Strings.StyleDisplayNone;
                    hm.DiversionYes = string.Empty;
                }
                else
                {
                    hm.DiversionNo = string.Empty;
                    hm.DiversionYes = Strings.StyleDisplayNone;
                }

                hm.OccupancyPercent = 0;
                List<Ward> wards = FacadeManager.EntityInterface.GetWardsByFacility(this.loggedUser.Facility.Id).ToList();
                StringBuilder wardIdList = new StringBuilder();
                IList<II> facilityIdList = new List<II>();
                facilityIdList.Add(this.loggedUser.Facility.Id);
                if (wards != null)
                {
                    foreach (Ward w in wards)
                    {
                        wardIdList.Append(w.Id.extension);
                        wardIdList.Append(",");
                    }
                }
                int timeZoneMinutesOffset = Convert.ToInt32(RepTimeZoneMinutesOffset);
                hm.Threshold = Convert.ToInt32(System.Configuration.ConfigurationManager.AppSettings["THRESHOLD"]);
                Guid facilityUid = Guid.Parse(this.loggedUser.Facility.Id.extension);
                DateTime? facilityAdmissionDate = DateTimeNowOnCurrentFacility;

                bool onlyCurrentWaitingAdmissions = true;
                bool onlyInHouseWaitingAdmissions = true;

                if (hm.View2Selected != null && hm.View2Selected.displayName.Equals(Strings.View_InHouse))
                    onlyInHouseWaitingAdmissions = true;
                else
                    onlyInHouseWaitingAdmissions = false;

                switch (hm.CurrentFilter)
                {
                    case Constants.CURRENT2:
                        hm.WaitingListFilterType = Strings.CurrentlyWaiting;
                        facilityAdmissionDate = DateTimeNowOnCurrentFacility;
                        onlyCurrentWaitingAdmissions = true;
                        break;
                    case Constants.PAST_30_DAYS:
                        onlyCurrentWaitingAdmissions = false;
                        hm.WaitingListFilterType = Strings.WaitingList_Past30;
                        facilityAdmissionDate = DateTimeNowOnCurrentFacility.AddDays(-30);
                        break;
                    case Constants.PAST_60_DAYS:
                        onlyCurrentWaitingAdmissions = false;
                        hm.WaitingListFilterType = Strings.WaitingList_Past60;
                        facilityAdmissionDate = DateTimeNowOnCurrentFacility.AddDays(-60);
                        break;
                    case Constants.PAST_90_DAYS:
                        onlyCurrentWaitingAdmissions = false;
                        hm.WaitingListFilterType = Strings.WaitingList_Past90;
                        facilityAdmissionDate = DateTimeNowOnCurrentFacility.AddDays(-90);
                        break;
                }
                hm.CurrentViewSelected = onlyCurrentWaitingAdmissions;
                
                List<SelectableEnum<DataRetrievalMethod>> retrievalMethods = GetRetrievalMethods();
                List<SelectableEnum<VI.Admin.VistaDataType>> dataTypesList = GetDataTypesList();
                List<SelectableEnum<JobStatus>> jobStatus = GetJobStatus().Where(a => a.EnumValue.ToString() == JobStatus.Succeeded.ToString() || a.EnumValue.ToString() == JobStatus.PartiallySucceeded.ToString()).ToList();

                List<BedOccupancyCount> bmsBedOccupancylist = new List<BedOccupancyCount>();
                int newEventsCount = 0;
                List<AdmissionInfo> admissionInfoList = new List<AdmissionInfo>();
                DateTime? bpLastRunDate = null;
                FacadeManager.ADTInterface.GetHomePageBMSData(this.loggedUser.VistaSite.Id, this.loggedUser.Facility.Id, wardIdList.ToString(), flags, timeZoneMinutesOffset,
                                                                facilityAdmissionDate.Value, onlyCurrentWaitingAdmissions, onlyInHouseWaitingAdmissions,
                                                                retrievalMethods.Select<SelectableEnum<DataRetrievalMethod>, DataRetrievalMethod>(sel => sel.EnumValue).ToList(),
                                                                dataTypesList.Select<SelectableEnum<VI.Admin.VistaDataType>, VI.Admin.VistaDataType>(sel => sel.EnumValue).ToList(),
                                                                jobStatus.Select<SelectableEnum<JobStatus>, JobStatus>(sel => sel.EnumValue).ToList(),
                                                                out bmsBedOccupancylist, out newEventsCount, out admissionInfoList, out bpLastRunDate);

                if (bmsBedOccupancylist.Count > 0)
                    hm.OccupancyPercent = bmsBedOccupancylist[0].OccupancyPercent;
                hm.EventsCount = newEventsCount;
                hm.AdmissionList = admissionInfoList;

                string bpLastRunDateText = string.Empty;
                bool isValidDateBPLastRan = false;
                if (bpLastRunDate.HasValue)
                {
                    bpLastRunDateText = string.Format("{0} {1}", bpLastRunDate.Value.ToString(Strings.USDate), " @ ");
                    if ((DateTimeNowOnCurrentFacility - bpLastRunDate.Value).TotalMinutes > 30)
                    {
                        isValidDateBPLastRan = false;
                        bpLastRunDateText += bpLastRunDate.Value.ToString(Strings.HHmmssDateTime);
                    }
                    else
                    {
                        isValidDateBPLastRan = true;
                        bpLastRunDateText += bpLastRunDate.Value.ToString(Strings.HHmmDateTime);
                    }
                }
                TempData["BPLastRunDateText"] = bpLastRunDateText;
                TempData["IsValidDateBPLastRan"] = isValidDateBPLastRan;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Builds the integrated sites.
        /// </summary>
        /// <param name="integratedSites">The integrated sites.</param>
        /// <param name="currentFacility">The current facility.</param>
        /// <returns></returns>
        private IList<Facility> BuildIntegratedSites(string integratedSites, Facility currentFacility)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<Facility> list = new List<Facility>();
                string[] identifiers = integratedSites.Split(',');
                Facility facility = null;
                II facilityId = null;
                foreach (string facilityIdentifier in identifiers)
                {
                    if (facilityIdentifier.Trim() != currentFacility.Id.extension)
                    {
                        facilityId = new II() { root = currentFacility.Id.root, extension = facilityIdentifier.Trim() };
                        if (this.loggedUser.IsSuperUser)
                            facility = FacadeManager.EntityInterface.GetFacility(facilityId);
                        else
                            if (FacadeManager.UserInterface.CheckBMSReadPermission(this.loggedUser, facilityId))
                                facility = FacadeManager.EntityInterface.GetFacility(facilityId);
                            else
                                continue;
                        if (facility != null)
                            list.Add(facility);
                    }
                }
                return list;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Sets the view2 selected.
        /// </summary>
        /// <param name="hm">The home model.</param>
        private void SetView2Selected(HomeViewModel hm)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (hm.View2List == null)
                    hm.View2List = FacadeManager.VocabularyInterface.GetVocabulary(BMS.Facade.Data.Util.Vocabulary.PatientWaitingViews);
                foreach (CD obj in hm.View2List)
                {
                    if (obj.code == hm.View2 || obj.displayName == hm.View2)
                    {
                        if (string.IsNullOrEmpty(hm.LastSelectedView) || hm.LastSelectedView != obj.code)
                        {
                            hm.LastSelectedView = obj.code;
                            hm.IsChangeSelectedView = true;
                        }
                        else
                        {
                            hm.IsChangeSelectedView = false;
                        }
                        hm.View2Selected = obj;
                        hm.View2 = obj.code;
                        break;
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion
    }
}
